/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.ruleGenerators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.classifiers.rules.lad.core.BinaryRule;
import weka.classifiers.rules.lad.core.Literal;
import weka.classifiers.rules.lad.ruleGenerators.RuleGenerator;
import weka.core.Option;
import weka.core.Utils;

public class RandomRuleGenerator
extends RuleGenerator {
    private static final long serialVersionUID = 1448802467208122870L;
    private int mNumRules = 250;
    private int mRandomSeed = 1;
    private int mNumRandomFeatures = 10;
    private double mMinRelativeCoverageOwnClass = 0.01;
    private Random mRandomObject = new Random();
    private int NUM_POSITIVE_INSTANCES = 0;
    private int NUM_NEGATIVE_INSTANCES = 0;

    @Override
    public void generateRules(BinaryData trainingData) {
        this.mTrainingData = trainingData;
        this.NUM_POSITIVE_INSTANCES = this.mTrainingData.numPositiveInstances();
        this.NUM_NEGATIVE_INSTANCES = this.mTrainingData.numNegativeInstances();
        this.mRandomObject.setSeed(this.mRandomSeed);
        int i = 0;
        while (i < this.mNumRules) {
            this.expand(true);
            this.expand(false);
            ++i;
        }
    }

    private void expand(boolean aClass) {
        RuleGenerator.Node covereds = new RuleGenerator.Node((RuleGenerator)this, this.mTrainingData);
        ArrayList<Literal> rule = new ArrayList<Literal>();
        int length = this.mTrainingData.numAttributes();
        int[] literalList = new int[length];
        int i = 0;
        while (i < this.mTrainingData.numAttributes()) {
            literalList[i] = i;
            ++i;
        }
        double purity = this.mMinimumPurity;
        while (length > 0) {
            Literal bestLiteral = null;
            RuleGenerator.Node bestLiteralCovering = null;
            int bestLiteralIndex = -1;
            Collection<Integer> randomIndexes = this.randomIndexes(length, this.mNumRandomFeatures);
            for (Integer index : randomIndexes) {
                int indexLiteral = this.getIndexValue(index);
                boolean signalLiteral = this.getIndexSignal(index);
                Literal literal = new Literal(literalList[indexLiteral], signalLiteral);
                RuleGenerator.Node literalCovering = this.getLiteralCovering(covereds, literal);
                if (bestLiteral == null) {
                    bestLiteral = literal;
                    bestLiteralCovering = literalCovering;
                    bestLiteralIndex = indexLiteral;
                    continue;
                }
                if (literalCovering.getPurity(aClass) > bestLiteralCovering.getPurity(aClass)) {
                    bestLiteral = literal;
                    bestLiteralCovering = literalCovering;
                    bestLiteralIndex = indexLiteral;
                    continue;
                }
                if (literalCovering.getPurity(aClass) != bestLiteralCovering.getPurity(aClass)) continue;
                if (aClass) {
                    if (literalCovering.numPositiveInstances() <= bestLiteralCovering.numPositiveInstances()) continue;
                    bestLiteral = literal;
                    bestLiteralCovering = literalCovering;
                    bestLiteralIndex = indexLiteral;
                    continue;
                }
                if (literalCovering.numNegativeInstances() <= bestLiteralCovering.numNegativeInstances()) continue;
                bestLiteral = literal;
                bestLiteralCovering = literalCovering;
                bestLiteralIndex = indexLiteral;
            }
            if (bestLiteral == null) break;
            rule.add(bestLiteral);
            covereds = bestLiteralCovering;
            literalList[bestLiteralIndex] = literalList[--length];
            if (!(this.coverage(covereds, aClass) >= this.mMinRelativeCoverageOwnClass)) break;
            if (!(covereds.getPurity(aClass) >= purity)) continue;
            purity = covereds.getPurity(aClass);
            purity += (1.0 - purity) / 10.0;
            this.addRule(new BinaryRule(rule, aClass, covereds.getPurity(aClass)));
            if (purity == 1.0) break;
        }
    }

    private RuleGenerator.Node getLiteralCovering(RuleGenerator.Node node, Literal literal) {
        int index = literal.getAtt();
        boolean signal = literal.getSign();
        RuleGenerator.Node covered = new RuleGenerator.Node(this);
        for (BinaryInstance obs : node.getPositiveInstances()) {
            if (obs.isMissingAttribute(index) || obs.getAttributeAt(index) != signal) continue;
            covered.addInstance(obs);
        }
        for (BinaryInstance obs : node.getNegativeInstances()) {
            if (obs.isMissingAttribute(index) || obs.getAttributeAt(index) != signal) continue;
            covered.addInstance(obs);
        }
        return covered;
    }

    private Collection<Integer> randomIndexes(int length, int quantity) {
        if (length > 0) {
            if (quantity > length) {
                quantity = length;
            }
        } else {
            return new ArrayList<Integer>(0);
        }
        int counter = 0;
        HashMap<Integer, Integer> sortedIndexes = new HashMap<Integer, Integer>();
        while (counter < quantity) {
            int index = this.mRandomObject.nextInt(length);
            boolean signal = this.mRandomObject.nextBoolean();
            if (sortedIndexes.containsKey(index = this.mountIndex(index, signal))) continue;
            sortedIndexes.put(index, index);
            ++counter;
        }
        return sortedIndexes.values();
    }

    private double coverage(RuleGenerator.Node n, boolean aClass) {
        if (aClass) {
            return (double)n.numPositiveInstances().intValue() / (double)this.NUM_POSITIVE_INSTANCES;
        }
        return (double)n.numNegativeInstances().intValue() / (double)this.NUM_NEGATIVE_INSTANCES;
    }

    @Override
    public void checkForExceptions() throws Exception {
        super.checkForExceptions();
        if (this.mNumRules < 25) {
            throw new Exception("Rule Generator: Number of Rules must be greater than or equal to 25.");
        }
        if (this.mNumRandomFeatures < 1) {
            throw new Exception("Rule Generator: Number of Random Features must be greater than or equal to 2.");
        }
        if (this.mMinRelativeCoverageOwnClass < 0.01) {
            throw new Exception("Rule Generator: Minimum Relative Coverage must be at least 0.01.");
        }
    }

    private int mountIndex(int index, boolean signal) {
        ++index;
        if (!signal) {
            return index * -1;
        }
        return index;
    }

    private int getIndexValue(int index) {
        if (!this.getIndexSignal(index)) {
            index *= -1;
        }
        return index - 1;
    }

    private boolean getIndexSignal(int index) {
        return index > 0;
    }

    public int getNumRules() {
        return this.mNumRules;
    }

    public void setNumRules(int mNumRules) {
        this.mNumRules = mNumRules;
    }

    public int getNumRandomFeatures() {
        return this.mNumRandomFeatures;
    }

    public void setNumRandomFeatures(int mNumRandomFeatures) {
        this.mNumRandomFeatures = mNumRandomFeatures;
    }

    public int getRandomSeed() {
        return this.mRandomSeed;
    }

    public void setRandomSeed(int mSeed) {
        this.mRandomSeed = mSeed;
    }

    public double getMinRelativeCoverageOwnClass() {
        return this.mMinRelativeCoverageOwnClass;
    }

    public void setMinRelativeCoverageOwnClass(double rel) {
        this.mMinRelativeCoverageOwnClass = rel;
    }

    @Override
    public String globalInfo() {
        return "Random rule generation algorithm";
    }

    public String numRulesTipText() {
        return "Number of rules that the algorithm attempts to generate.";
    }

    public String numRandomFeaturesTipText() {
        return "Number of features sampled at each iteration during rule construction.";
    }

    public String randomSeedTipText() {
        return "Seed used by internal random number generator.";
    }

    public String minRelativeCoverageOwnClassTipText() {
        return "How much coverage of its own class a rule must have in order to be accepted.";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-nft");
        options.add("" + this.getNumRandomFeatures());
        options.add("-nrd");
        options.add("" + this.getNumRules());
        options.add("-rgs");
        options.add("" + this.getRandomSeed());
        options.add("-mc");
        options.add("" + this.getMinRelativeCoverageOwnClass());
        return options.toArray(new String[options.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String randomSeed;
        String numRules;
        String numRandomFeatures = Utils.getOption("nft", options);
        if (numRandomFeatures.length() != 0) {
            this.setNumRandomFeatures(Integer.parseInt(numRandomFeatures));
        }
        if ((numRules = Utils.getOption("nrd", options)).length() != 0) {
            this.setNumRules(Integer.parseInt(numRules));
        }
        if ((randomSeed = Utils.getOption("rgs", options)).length() != 0) {
            this.setRandomSeed(Integer.parseInt(randomSeed));
        }
        String minRelativeCoverage = Utils.getOption("mc", options);
        if (randomSeed.length() != 0) {
            this.setMinRelativeCoverageOwnClass(Double.parseDouble(minRelativeCoverage));
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tNumber of Random Features. Number of features sampled at each\n\titeration during rule construction.\n", "nft", 1, "-nft <rand_features>"));
        newVector.addElement(new Option("\tNumber of Rules. Number of rules that the algorithm attempts\n\tto generate.\n", "nrd", 1, "-nrd <number_rules>"));
        newVector.addElement(new Option("\tRandom Seed. Seed used by internal random number generator.\n", "rgs", 1, "-rgs <seed>"));
        newVector.addElement(new Option("\tMinimum Relative Coverage. How much coverage of its\n\town class a rule must have in order to be accepted.\n", "mc", 1, "-mc <min_rel_cover>"));
        return newVector.elements();
    }
}

